local assets =
{
	Asset("ANIM", "anim/smallbonestew.zip"),
    Asset("ATLAS", "images/inventoryimages/smallbonestew.xml"),
	Asset("ANIM", "anim/underboiled_kabobs.zip"),
    Asset("ATLAS", "images/inventoryimages/underboiled_kabobs.xml"),
	Asset("ANIM", "anim/cuisine.zip"),
    Asset("ATLAS", "images/inventoryimages/water.xml"),
	Asset("ATLAS", "images/inventoryimages/suc.xml"),
	Asset("ATLAS", "images/inventoryimages/nacl.xml"),
}

local function xiaoroutangfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("smallbonestew")
    inst.AnimState:SetBuild("smallbonestew")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "smallbonestew"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/smallbonestew.xml"
    inst:AddComponent("selfstacker")
	--食物组件
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	 inst:AddComponent("edible")
    inst.components.edible.healthvalue = 6
    inst.components.edible.hungervalue = 30
	inst.components.edible.sanityvalue = 2
    inst.components.edible.foodtype = FOODTYPE.MEAT

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function shengrouchuanfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("underboiled_kabobs")
    inst.AnimState:SetBuild("underboiled_kabobs")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "underboiled_kabobs"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/underboiled_kabobs.xml"
    inst:AddComponent("selfstacker")
	--食物组件
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
	inst:AddComponent("edible")
    inst.components.edible.healthvalue = 1
    inst.components.edible.hungervalue = 18
	inst.components.edible.sanityvalue = -20
    inst.components.edible.foodtype = FOODTYPE.MEAT
	inst:AddComponent("cookable")
    inst.components.cookable.product = "kabobs"

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function waterfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cuisine")
    inst.AnimState:SetBuild("cuisine")
    inst.AnimState:PlayAnimation("water")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "water"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/water.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function naclfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cuisine")
    inst.AnimState:SetBuild("cuisine")
    inst.AnimState:PlayAnimation("nacl")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "nacl"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nacl.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
local function sucfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cuisine")
    inst.AnimState:SetBuild("cuisine")
    inst.AnimState:PlayAnimation("suc")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
	inst:AddComponent("tradable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "suc"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/suc.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab("underboiled_kabobs", shengrouchuanfn, assets),
 Prefab("smallbonestew", xiaoroutangfn, assets),
 Prefab("water", waterfn, assets),
 Prefab("suc", sucfn, assets),
 Prefab("nacl", naclfn, assets)